# Can Naive Bayes models be used to provide new product recommendations for FitBits

#Prepare a clean R environment in work space.
rm(list=ls())

#Use setwd() to navigate the data directory and specify desired folder. Here we are using Rstudio Editor directory.
setwd(dirname(rstudioapi::getSourceEditorContext()$path))

#Import our csv file data
data=read.csv("iHealthData.csv")
names(data)=c("Main Interest","Current Exercise Level", "How Motivated", "Comfortable with tech Devices?", "Model #")


#Use the NB classifier on test Data
iHealth_classifier=function(interest,exercise,motivation,comfortlevel){
  #interest='health'
  #exercise='moderate'
  #motivation='moderate'
  #comfortlevel='yes'
  
  vars=c(interest,exercise,motivation,comfortlevel)
  #data=read.table("i-01.txt")
  data=read.csv("iHealthData.csv")
  names(data)=c("Main Interest","Current Exercise Level", "How Motivated", "Comfortable with tech Devices?", "Model #")
  
  uniquevec=unique(data$'Model #')  #Unique Model Choices
  val=length(uniquevec)
  
  ProbMat=matrix(0,(dim(data)[2]),val) 
  
  #compute probabilities
  for (i in 1:(dim(ProbMat)[1])){
    for (j in 1:val){
      data_cond=subset(data,data$`Model #`==uniquevec[j])  #Model type
      
      if (i<dim(ProbMat)[1]){
        probval=dim(subset(data_cond,data_cond[,i]==vars[i]))[1]/dim(data_cond)[1]}  #Compute probability of model being chosen
      
      else
        
      {probval=dim(data_cond)[1]/dim(data)[1]}  #Compute marginal probabilities
      
      ProbMat[i,j]=probval
    }
    
  }
  
  finalvec=apply(ProbMat,2,prod)
  finalval=which.max(finalvec)
  choice=uniquevec[finalval]
  return(list(ProbMat=ProbMat,finalvec=finalvec,choice=choice))
}

#}
#data_i100=subset(data,data$`Model #`=='i100')


#data_i500=subset(data,data$`Model #`=='i500')}

#Executing function in a sample data set to provide new product recommendations
Ex1<-iHealth_classifier(interest="both",exercise="active",motivation ="aggressive",comfortlevel = "yes")
Ex2<-iHealth_classifier(interest="appearance",exercise="sedentary",motivation ="moderate",comfortlevel = "yes")

